#!/bin/bash
# ============================================
#  Amazon Linux 2 Shadowsocks 一键安装脚本
#  功能：
#   ✔ 安装 python3 + pip
#   ✔ 安装 Shadowsocks
#   ✔ 安装 libsodium
#   ✔ 生成 config.json（端口 255998 / AES-128-GCM）
#   ✔ 创建 systemd 服务（开机自动启动）
#   ✔ 启用 BBR + FQ（开机自动生效）
# ============================================

SSR_PORT=43998
SSR_PASS="kang8844Po"
CONFIG_PATH="/etc/shadowsocks/config.json"

echo "==== 更新系统 ===="
yum update -y

echo "==== 安装必要组件 ===="
yum install -y python3 python3-pip epel-release
pip3 install https://github.com/shadowsocks/shadowsocks/archive/master.zip

echo "==== 安装 libsodium ===="
yum install -y libsodium libsodium-devel

echo "==== 创建 Shadowsocks 配置文件 ===="
mkdir -p /etc/shadowsocks

cat > $CONFIG_PATH <<EOF
{
    "server": "0.0.0.0",
    "server_port": $SSR_PORT,
    "password": "$SSR_PASS",
    "method": "aes-128-gcm",
    "timeout": 300,
    "fast_open": true,
    "mode": "tcp_and_udp"
}
EOF

echo "==== 创建 systemd 服务 ===="
cat > /etc/systemd/system/shadowsocks.service <<EOF
[Unit]
Description=Shadowsocks Server
After=network.target

[Service]
ExecStart=/usr/local/bin/ssserver -c /etc/shadowsocks/config.json
Restart=always
User=root
LimitNOFILE=1000000

[Install]
WantedBy=multi-user.target
EOF

echo "==== 启用自启动并启动 Shadowsocks ===="
systemctl daemon-reload
systemctl enable shadowsocks
systemctl start shadowsocks

echo "==== 放行防火墙端口 ===="
firewall-cmd --add-port=$SSR_PORT/tcp --permanent
firewall-cmd --add-port=$SSR_PORT/udp --permanent
firewall-cmd --reload

echo "==== 设置 BBR + FQ 优化 ===="
cat > /etc/sysctl.d/99-ss-speed.conf <<EOF
fs.file-max = 1000000
net.core.rmem_max = 67108864
net.core.wmem_max = 67108864
net.ipv4.tcp_rmem = 4096 87380 67108864
net.ipv4.tcp_wmem = 4096 65536 67108864
net.ipv4.tcp_congestion_control = bbr
net.core.default_qdisc = fq
EOF

sysctl --system

echo "==== 启用 BBR ===="
modprobe tcp_bbr
echo "tcp_bbr" >> /etc/modules-load.d/bbr.conf

echo "==== 检查 BBR 是否生效 ===="
sysctl net.ipv4.tcp_congestion_control
lsmod | grep bbr

echo ""
echo "==========================================="
echo " Shadowsocks 安装成功！"
echo " 配置文件: $CONFIG_PATH"
echo " 端口: $SSR_PORT"
echo " 密码: $SSR_PASS"
echo " 加密: aes-128-gcm"
echo ""
echo " BBR + FQ 已启用并开机自启！"
echo " Shadowsocks 已开机自启！"
echo "==========================================="
